/****************************************************************************
*
*    Copyright (c) 2005 - 2014 by Vivante Corp.  All rights reserved.
*
*    The material in this file is confidential and contains trade secrets
*    of Vivante Corporation. This is proprietary information owned by
*    Vivante Corporation. No part of this work may be disclosed,
*    reproduced, copied, transmitted, or used in any way for any purpose,
*    without the express written permission of Vivante Corporation.
*
*****************************************************************************/


/*!
 @header Error values
 Error values returned by both user and kernel functions.

 @copyright Vivante Corporation
 */

#ifndef _tiny_ui_error_h_
#define _tiny_ui_error_h_

#ifdef __cplusplus
extern "C" {
#endif

#if 0
#pragma mark Types
#endif

/*!
 @abstract Error codes that the tiny_ui functions can return.

 @discussion
 All API functions return a status code. On success, <code>TINY_UI_SUCCESS</code> will be returned when a function is
 successful. This value is set to zero, so if any function returns a non-zero value, an error has occured.
 */
typedef enum tiny_ui_error
{
    TINY_UI_SUCCESS = 0,        /*! Success. */
    TINY_UI_INVALID_ARGUMENT,   /*! An invalid argument was specified. */
    TINY_UI_OUT_OF_MEMORY,      /*! Out of memory. */
    TINY_UI_NO_CONTEXT,         /*! No context or an unintialized context specified. */
    TINY_UI_TIMEOUT,            /*! A timeout has occured during a wait. */
    TINY_UI_OUT_OF_RESOURCES,   /*! Out of system resources. */
    TINY_UI_GENERIC_IO          /*! Cannot communicate with the kernel driver. */
}
tiny_ui_error_t;

#ifdef __cplusplus
}
#endif
#endif /* _tiny_ui_error_h_ */
